/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl;

import com.ibm.hwmca.fw.servlet.pmod.ModelConstants;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.servlet.pmod.impl.PanelModelRegistryImpl;
import com.ibm.hwmca.fw.servlet.pmod.impl.StackedInputStream;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ModelResources
implements ModelConstants {
    public static final String TRACE_MASK = "XPMIMRS";
    private static ResourceBundle theBundle = null;
    public static final String FMT_BUNDLE_LEADER = "\n<fmt:bundle basename=\"";
    public static final byte[] FMT_BUNDLE_TERMINATOR = "\n</fmt:bundle>".getBytes();
    public static final String HMC_CONTEXT_LEADER = "\n<hmc:context modelID=\"";
    public static final byte[] HMC_CONTEXT_TERMINATOR = "\n</hmc:context>".getBytes();
    public static final String WCL_FOUNDATION_LEADER = "\n<wcl:Foundation objectScope=\"";
    public static final byte[] WCL_FOUNDATION_TERMINATOR = "\n</wcl:Foundation>".getBytes();
    public static final byte[] WCL_CONTAINER_LEADER = "\n<wcl:WContainer>".getBytes();
    public static final byte[] WCL_CONTAINER_TERMINATOR = "\n</wcl:WContainer>".getBytes();
    public static final byte[] WCL_FDA_LAYOUT_LEADER = "\n<wcl:WFDALayout>".getBytes();
    public static final byte[] WCL_FDA_LAYOUT_TERMINATOR = "\n</wcl:WFDALayout>".getBytes();
    public static final byte[] WCL_FDA_TOGGLER_LEADER = "\n<wcl:FDAToggler/>".getBytes();
    public static byte[] obligatoryDocumentFrontContent = null;

    public static synchronized ResourceBundle getModelResources() throws MissingResourceException {
        if (theBundle == null) {
            theBundle = ResourceBundle.getBundle("com.ibm.hwmca.fw.servlet.pmod.impl.res.model");
        }
        return theBundle;
    }

    public static int formParseStream(boolean nested, PanelModel panelModel, StackedInputStream stackedInputStream, InputStream documentInputStream, String wcl_objectScope, String wcl_objectScopeId, String fmtBundleBaseName) throws PanelModelException {
        Trace.trace("XPMMODCF", "formParseStream() entry");
        boolean includeFmtBundle = fmtBundleBaseName != null && !"".equals(fmtBundleBaseName);
        int modelAddedFrontMatter = 0;
        stackedInputStream.push(new ByteArrayInputStream(HMC_CONTEXT_TERMINATOR));
        if (includeFmtBundle) {
            stackedInputStream.push(new ByteArrayInputStream(FMT_BUNDLE_TERMINATOR));
        }
        if (!nested) {
            stackedInputStream.push(new ByteArrayInputStream(WCL_FOUNDATION_TERMINATOR));
        }
        if (nested) {
            stackedInputStream.push(new ByteArrayInputStream(WCL_CONTAINER_TERMINATOR));
        }
        stackedInputStream.push(new BufferedInputStream(documentInputStream, 8192));
        if (nested) {
            stackedInputStream.push(new ByteArrayInputStream(WCL_CONTAINER_LEADER));
            modelAddedFrontMatter += WCL_CONTAINER_LEADER.length;
        }
        if (!nested) {
            byte[] fndLeader = (WCL_FOUNDATION_LEADER + wcl_objectScope + "\" objectScopeId=\"" + wcl_objectScopeId + "\">").getBytes();
            modelAddedFrontMatter += fndLeader.length;
            stackedInputStream.push(new ByteArrayInputStream(fndLeader));
        }
        if (includeFmtBundle) {
            byte[] fmtLeader = (FMT_BUNDLE_LEADER + fmtBundleBaseName + "\">").getBytes();
            modelAddedFrontMatter += fmtLeader.length;
            stackedInputStream.push(new ByteArrayInputStream(fmtLeader));
        }
        String modelId = "UNREGISTERED";
        if (panelModel != null) {
            modelId = PanelModelRegistryImpl.getRegistry().registerModel(panelModel);
        }
        byte[] hmcLeader = (HMC_CONTEXT_LEADER + modelId + "\">").getBytes();
        modelAddedFrontMatter += hmcLeader.length;
        stackedInputStream.push(new ByteArrayInputStream(hmcLeader));
        if (obligatoryDocumentFrontContent != null && !nested) {
            modelAddedFrontMatter += obligatoryDocumentFrontContent.length;
            stackedInputStream.push(new ByteArrayInputStream(obligatoryDocumentFrontContent));
        }
        return modelAddedFrontMatter;
    }

    private ModelResources() {
    }

    static {
        try {
            ResourceBundle rb = ModelResources.getModelResources();
            boolean done = false;
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements() && !done) {
                String key = e.nextElement();
                if (!"obligatory.front.content".equals(key)) continue;
                obligatoryDocumentFrontContent = rb.getString(key).getBytes();
                done = true;
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
    }
}

